#include "../generator.h"
#include "../bdtypes.h"
#include "../bdfunc.h"
#include "../bdglobal.h"

#define FOND_Z 1.f
/*
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  0,0,0,   0,128.f,1.f/FOND_Z,{8,8, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{248.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{248.f/FOND_Z,248.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   0,0,0,   0,128.f,1.f/FOND_Z,{8,248.f/FOND_Z,1.f/FOND_Z}};
*/
static GrVertex Fond1 = {0.f,0.f,FOND_Z,  92,0,0,   0,128.f,1.f/FOND_Z,{0,0, 1.f/FOND_Z}};
static GrVertex Fond2 = {640.f,0,FOND_Z,   0,92,0,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,0,1.f/300.f}};
static GrVertex Fond3 = {640.,480.,FOND_Z,   0,0,92,   0,128.f,1.f/FOND_Z,{256.f/FOND_Z,256.f/FOND_Z,1.f/FOND_Z}};
static GrVertex Fond4 = {0,480.,FOND_Z,   92,0,92,   0,128.f,1.f/FOND_Z,{0,256.f/FOND_Z,1.f/FOND_Z}};

static int MiniSin[256], MiniCos[256];

void LInit_Onde()
{
	int Cpt1;

	for(Cpt1=0;Cpt1<256;Cpt1++)
	{
		MiniSin[Cpt1] = 64.f*sin(Cpt1*PI2/256.f);
		MiniCos[Cpt1] = 64.f*cos(Cpt1*PI2/256.f);
	}
}

void QInit_Onde()
{
	grDepthBufferMode(GR_DEPTHBUFFER_DISABLE);
	grAlphaCombine(GR_COMBINE_FUNCTION_LOCAL, GR_COMBINE_FACTOR_ONE,
		 GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_CONSTANT, FXFALSE);
	grAlphaBlendFunction(GR_BLEND_ONE, GR_BLEND_ZERO, GR_BLEND_ZERO, GR_BLEND_ZERO);
	grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
		 GR_COMBINE_FACTOR_ONE,
		GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	grCullMode(GR_CULL_DISABLE);

	grChromakeyMode(GR_CHROMAKEY_DISABLE);
	grFogMode(GR_FOG_DISABLE);

	g_TextureBuff.info.format = GR_TEXFMT_RGB_565;
	SelectTexture(g_TextureBuff);
}

void Effect_Onde()
{
	int Cpt1, Cpt2;
	WORD *pDst, *pSrc;
	float SinTmp, CosTmp;
	static float fZoom = 60;
	DWORD dwTmp;

	pDst = (WORD*)g_FrameBuf3d;
	pSrc = g_PicTour;

	if (g_demostate.TickInEffect<1024)
	{
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER_ADD_LOCAL,
			GR_COMBINE_FACTOR_ONE,
			GR_COMBINE_LOCAL_CONSTANT, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
		dwTmp = 256-(g_demostate.TickInEffect*256/1024);
		dwTmp = CLIP_DW(dwTmp);
		grConstantColorValue(dwTmp|(dwTmp<<8)|(dwTmp<<16));
	}
	else
	{
		grColorCombine(GR_COMBINE_FUNCTION_SCALE_OTHER,
			 GR_COMBINE_FACTOR_ONE,
			GR_COMBINE_LOCAL_NONE, GR_COMBINE_OTHER_TEXTURE, FXFALSE);
	}

	for(Cpt1=0;Cpt1<256;Cpt1++)
	{
		for(Cpt2=0;Cpt2<256;Cpt2++)
		{
			*(pDst++) = 
				pSrc[
				((Cpt1+MiniSin[(-g_demostate.TickInEffect/8+Cpt2+Cpt1)&255])&255)*256
				+(Cpt2+MiniCos[(Cpt2-Cpt1)&255]&255)
				];
		}
		//pDst += 16;
	}

	grTexDownloadMipMap(g_TextureBuff.tmu, g_TextureBuff.start,
						g_TextureBuff.evenOdd, &g_TextureBuff.info);

	//fZoom = 120+g_demostate.TickInEffect/8;
	if (g_demostate.TickInEffect>3000)
		fZoom = 420-360.f*(float)cos((g_demostate.TickInEffect-3000)/3500.f*PI);

	CosTmp = fZoom*(float)cos(g_demostate.TickInEffect/800.f);
	SinTmp = fZoom*(float)sin(g_demostate.TickInEffect/800.f);

	Fond4.tmuvtx[0].tow = Fond1.tmuvtx[0].sow = (fZoom + SinTmp)/FOND_Z;
	Fond1.tmuvtx[0].tow = Fond2.tmuvtx[0].sow = (fZoom + CosTmp)/FOND_Z;
	Fond2.tmuvtx[0].tow = Fond3.tmuvtx[0].sow = (fZoom - SinTmp)/FOND_Z;
	Fond3.tmuvtx[0].tow = Fond4.tmuvtx[0].sow = (fZoom - CosTmp)/FOND_Z;

	grDrawTriangle(&Fond1, &Fond2, &Fond3);
	grDrawTriangle(&Fond3, &Fond4, &Fond1);

}

void ByeBye_Onde()
{


}
